---
generated_at: 2026-01-21 16:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Config Scheduler Job

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00009.sql` (行1-475)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1170-1386)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行11)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは9である | E-01（行15: p_id=>9） | ○ |
| C-02 | エイリアスはCONFIG-SCHEDULER-JOBである | E-01（行17: p_alias=>'CONFIG-SCHEDULER-JOB'） | ○ |
| C-03 | Protection LevelはCである | E-01（行23: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | ダイアログ幅は1500px | E-01（行22: p_dialog_width=>'1500px'） | ○ |
| C-06 | Job Historyリージョンは展開状態 | E-01（行29: is-expanded） | ○ |
| C-07 | History ReportはQA_JOB_RUN_DETAILS_P0009_Vを使用 | E-01（行64: p_query_table=>'QA_JOB_RUN_DETAILS_P0009_V'） | ○ |
| C-08 | 表示行数は5行 | E-01（行69: p_query_num_rows=>5） | ○ |
| C-09 | データなしメッセージは「The Cronjob has not run recently.」 | E-01（行71: p_query_no_data_found） | ○ |
| C-10 | RUN_CRONJOB_NOWはジョブが実行中でない場合に表示 | E-01（行183-185: p_button_condition） | ○ |
| C-11 | CRONJOB_IN_PROGRESSはジョブが実行中の場合に表示 | E-01（行199-201: p_button_condition） | ○ |
| C-12 | REFRESHボタンはJavaScriptでリロード | E-01（行407: 'location.reload()'） | ○ |
| C-13 | P9_ENABLE_SCHEDULER_JOBはYes/No形式 | E-01（行362: p_display_as=>'NATIVE_YES_NO'） | ○ |
| C-14 | P9_ENABLE_SCHEDULER_JOBのソースはf_is_scheduler_cronjob_enabled | E-01（行359: p_source） | ○ |
| C-15 | P9_CRONJOB_NAMEはf_get_job_nameから取得 | E-01（行257: p_source） | ○ |
| C-16 | Load informationはQA_JOB_DETAILS_P0009_Vから取得 | E-01（行457: p_process_sql_clob） | ○ |
| C-17 | Save処理はp_enable_scheduler_cronjobを呼び出す | E-01（行415: process_sql_clob） | ○ |
| C-18 | 成功メッセージは「Saved.」 | E-01（行419: p_process_success_message） | ○ |
| C-19 | Trigger処理はp_trigger_scheduler_cronjobを呼び出す | E-01（行428: process_sql_clob） | ○ |
| C-20 | Cronjob開始メッセージは「Cronjob started.」 | E-01（行432: p_process_success_message） | ○ |
| C-21 | f_is_scheduler_cronjob_enabledでCronjob有効状態を確認 | E-02（行1304-1333） | ○ |
| C-22 | p_enable_scheduler_cronjobでdbms_scheduler.enable/disableを呼び出す | E-02（行1351-1356） | ○ |
| C-23 | p_trigger_scheduler_cronjobでdbms_scheduler.run_jobを呼び出す | E-02（行1374） | ○ |
| C-24 | f_is_job_runningでジョブ実行中かを確認 | E-02（行1269-1302） | ○ |
| C-25 | f_get_job_nameでジョブ名を取得 | E-02（行1170-1220） | ○ |
| C-26 | AutocompleteはOFFに設定 | E-01（行20: p_autocomplete_on_off=>'OFF'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_JOB_DETAILS_P0009_Vビューが正しく定義されているか確認
- [ ] QA_JOB_RUN_DETAILS_P0009_Vビューが正しく定義されているか確認
- [ ] スケジューラーCronjobが事前に作成されているか確認
- [ ] Cronjobの実行権限（DBMS_SCHEDULER）が適切に付与されているか確認
- [ ] ジョブ実行中の状態表示が正しく更新されるか確認
- [ ] 長時間実行ジョブの場合のタイムアウト設定を確認
